/*
*********************************************************************************************************
*                                                ALLD_lib.h
*
* Description : This is the Header file.
*
*
*
*********************************************************************************************************
*/

#ifndef ALLD_LIB_H_
#define ALLD_LIB_H_
#define _USE_MATH_DEFINES

/*
************************************************************************************************************************
*                                                 INCLUDE LIBRARIES FILES
************************************************************************************************************************
*/

#include <thread>
#include <vector>
#include <ostream>
#include <opencv2/core.hpp>
#include <iostream>
#include <opencv2/opencv.hpp>
#include <stdio.h>
#include <stdarg.h>
#include <math.h>

/*
************************************************************************************************************************
*                                                 DEFINE MACRO
************************************************************************************************************************
*/

#define PI 3.14159265

/*
************************************************************************************************************************
*                                                 GLOBAL STRUCT
************************************************************************************************************************
*/

// struct that contains vector points of window for left and right lines
struct Points {
	std::vector<cv::Point> leftFit_windowLine1, leftFit_windowLine2;
	std::vector<cv::Point> rightFit_windowLine1, rightFit_windowLine2;
};

/*
************************************************************************************************************************
*                                                 FUNCTION PROTOTYPES
************************************************************************************************************************
*/

void show_and_save(std::string filename, cv::Mat image, std::string file_extension, bool show = true, bool save = true);

void display_images(std::vector<cv::Mat> images, std::string title);

void polyfit(const cv::Mat& src_x, const cv::Mat& src_y, cv::Mat& dst, int order);

void binary_transform(const cv::Mat& image, cv::Mat& warped, cv::Mat& M, cv::Mat& Minv, cv::Mat& combined, std::string extension);

void combined_threshold(cv::Mat const& img, cv::Mat& dst, std::string extension);

void apply_color_threshold(cv::Mat const& img, cv::Mat& color, std::string file_extension);

cv::Mat apply_combined_threshold(cv::Mat const& gradient, cv::Mat const& color, std::string file_extension);

cv::Mat apply_threshold(cv::Mat const& sob_x, cv::Mat const& sob_y, cv::Mat const& magn, cv::Mat const& dir, std::string file_extension);

void abs_sobel_threshold(cv::Mat const& src, cv::Mat& dest, char orient = 'x', int kernel_size = 3, int thresh_min = 0, int thresh_max = 255);

void Gauss_Blur(cv::Mat const& img, cv::Mat& dst, int kernel = 3);

void magnitude_threshold(cv::Mat const& src, cv::Mat& dest, int kernel_size = 3, int thresh_min = 0, int thresh_max = 255);

void direction_threshold(cv::Mat const& src, cv::Mat& dest, int kernel_size = 3, double thresh_min = 0, double thresh_max = PI / 2);

void change_Size(cv::Mat const& input, cv::Mat& dest, cv::Size size);

void color_thresh(cv::Mat const& channels, cv::Mat& color, char type_color = 's');

void ROI(const cv::Mat& image, std::vector<cv::Point2f> const& points, std::string extension);

void get_histogram(cv::Mat const& input, cv::Mat& out);

void print_vector(std::vector<double> vec);

std::string getFileExt(const std::string& s);

template<typename T>
std::vector<double> linspace(T start_in, T end_in, int num_in);

Points draw_poly_lines(cv::Mat const& input, std::vector<cv::Point>& leftPt, std::vector<cv::Point>& rightPt, std::vector<cv::Point>& leftFitPt, std::vector<cv::Point>& rightFitPt, std::vector<float>& leftFit_x, std::vector<float>& rightFit_x);

Points sliding_window(cv::Mat const& input, cv::Mat& hist, cv::Mat& win, std::vector<cv::Point>& leftPt, std::vector<cv::Point>& rightPt, std::vector<cv::Point>& leftFitPt, std::vector<cv::Point>& rightFitPt, std::vector<float>& leftFit_x, std::vector<float>& rightFit_x);

void clear_Fit_Point(std::vector<cv::Point>& leftFitPt, std::vector<cv::Point>& rightFitPt, Points& pt);

void draw_lane_lines(cv::Mat const& input, cv::Mat& finale, cv::Mat Minv, std::vector<cv::Point>& leftFitPt, std::vector<cv::Point>& rightFitPt, Points& pt);

float measure_curvature(std::vector<float>& Fit_x, int height);

float measure_vehicle_offset(std::vector<float>& leftFit_x, std::vector<float>& rightFit_x, std::string& direction, int width);

#endif // ALLD_LIB_H_
